/*--------------------------------------------------------------------------
SC92F848x_C.H

C Header file for SC92F848x microcontroller.
Copyright (c) 2021 Shenzhen SinOne Microelectronics Co., Ltd.
All rights reserved.
Ԫ΢޹˾
汾:  V1.2    
:  2021.07.14
--------------------------------------------------------------------------*/
#ifndef _SC92F848x_H_
#define _SC92F848x_H_

///* ------------------- ֽڼĴ-------------------- */
/*CPU*/
sfr   ACC  = 0XE0;  //ۼ
sfr   B    = 0XF0;  //BĴ		
sfr   PSW  = 0XD0;  //״ּ̬Ĵ		
sfr   DPH  = 0X83;  //DPTRָλ		
sfr   DPL  = 0X82;  //DPTRָλ		
sfr   SP   = 0X81;  //ջָ	
sfr   EXA0 = 0XE9;  //չۼ0
sfr   EXA1 = 0XEA;  //չۼ1
sfr   EXA2 = 0XEB;  //չۼ2
sfr   EXA3 = 0XEC;  //չۼ3
sfr   EXBL = 0XED;  //չBĴ0
sfr   EXBH = 0XEE;  //չBĴ1

/*SRAM*/
sfr   EXADH = 0XF7;  //ⲿSRAMַλ

/*system*/
sfr   PCON = 0X87;  //ԴƼĴ

/*Interrupt*/
sfr   IP1 = 0XB9;  //жȼƼĴ1
sfr   IP  = 0XB8;  //жȨƼĴ
sfr   IE  = 0XA8;  //жϿƼĴ
sfr   IE1 = 0XA9;  //жϿƼĴ1

/*PORT*/
sfr   IOHCON = 0X97;  //IOHüĴ
sfr   P5PH   = 0XDA;  //P5ƼĴ
sfr   P5CON  = 0XD9;  //P5/ƼĴ
sfr   P5     = 0XD8;  //P5ݼĴ
sfr   P2PH	 = 0XA2;  //P2ƼĴ		
sfr	  P2CON	 = 0XA1;  //P2/ƼĴ	
sfr   P2     = 0XA0;  //P2ݼĴ
sfr   P1PH	 = 0X92;  //P1ƼĴ		
sfr	  P1CON	 = 0X91;  //P1/ƼĴ
sfr   P1     = 0X90;  //P1ݼĴ
sfr	  P0PH	 = 0X9B;  //P0ƼĴ
sfr   P0VO   = 0X9C;  //P0LCDѹĴ
sfr	  P0CON	 = 0X9A;  //P0/ƼĴ	
sfr   P0     = 0X80;  //P0ݼĴ

/*TIMER*/	
sfr   TMCON  = 0X8E;  //ʱƵʿƼĴ
sfr   TH1    = 0X8D;  //ʱ18λ
sfr   TH0    = 0X8C;  //ʱ08λ
sfr   TL1    = 0X8B;  //ʱ18λ
sfr   TL0    = 0X8A;  //ʱ08λ
sfr   TMOD   = 0X89;  //ʱģʽĴ
sfr   TCON   = 0X88;  //ʱƼĴ
sfr   T2CON  = 0XC8;  //ʱ2ƼĴ
sfr   T2MOD  = 0XC9;  //ʱ2ģʽĴ
sfr   RCAP2L = 0XCA;  //ʱ2/׽8λ
sfr   RCAP2H = 0XCB;  //ʱ2/׽8λ
sfr   TL2    = 0XCC;  //ʱ28λ
sfr   TH2    = 0XCD;  //ʱ28λ

/*ADC*/
sfr   ADCCFG2 = 0XAA;  //ADCüĴ2
sfr	  ADCCFG1 = 0XAC;  //ADCüĴ1
sfr	  ADCCFG0 = 0XAB;  //ADCüĴ0
sfr   ADCCON  = 0XAD;  //ADCƼĴ
sfr   ADCVL   = 0XAE;  //ADCĴ
sfr   ADCVH   = 0XAF;  //ADCĴ

/*PWM*/
sfr   PWMCFG  = 0XD1;  //PWMüĴ
sfr   PWMCON  = 0XD2;  //PWMƼĴ
sfr   PWMPRD  = 0XD3;  //PWMüĴ
sfr   PWMDTYA = 0XD4;  //PWMռձüĴA
sfr   PWMDTY0 = 0XD5;  //PWM0üĴ
sfr   PWMDTY1 = 0XD6;  //PWM1ռձüĴ
sfr   PWMDTY2 = 0XD7;  //PWM2ռձüĴ
sfr   PWMDTYB = 0XDC;  //PWMռձüĴB
sfr   PWMDTY3 = 0XDD;  //PWM3ռձüĴ/PWMʱüĴ
sfr   PWMDTY4 = 0XDE;  //PWM4ռձüĴ
sfr   PWMDTY5 = 0XDF;  //PWM5ռձüĴ

/*WatchDog*/
sfr   WDTCON = 0XCF;  //WDTƼĴ

/*BTM*/
sfr	  BTMCON = 0XCE;  //ƵʱƼĴ

/*INT*/
sfr   INT0F = 0XBA;  //INT0 ½жϿƼĴ
sfr   INT0R = 0XBB;  //INT0 ϽжϿƼĴ
sfr   INT1F = 0XBC;  //INT1 ½жϿƼĴ
sfr   INT1R = 0XBD;  //INT1 ϽжϿƼĴ
sfr   INT2F = 0XC6;  //INT2 ½жϿƼĴ
sfr   INT2R = 0XC7;  //INT2 ϽжϿƼĴ

/*IAP */
sfr   IAPCTL = 0XF6;  //IAPƼĴ
sfr   IAPDAT = 0XF5;  //IAPݼĴ
sfr   IAPADE = 0XF4;  //IAPչַĴ
sfr   IAPADH = 0XF3;  //IAPдַλĴ
sfr   IAPADL = 0XF2;  //IAPдַλĴ
sfr   IAPKEY = 0XF1;  //IAPĴ

/*uart0*/
sfr   SCON  = 0X98;  //ڿƼĴ
sfr   SBUF  = 0X99;  //ݻĴ
sfr   OTCON = 0X8F;  //ƼĴ

/*һ*/
sfr   SSCON0 = 0X9D;  //USCIƼĴ0
sfr   SSCON1 = 0X9E;  //USCIƼĴ1
sfr   SSCON2 = 0X95;  //USCIƼĴ2
sfr   SSDAT  = 0X9F;  //USCIݼĴ3

/*OPTION*/
sfr   OPINX = 0XFE;  //Customer Optionָ 
sfr   OPREG = 0XFF;  //Customer OptionĴ

/*Check Sum*/
sfr   CHKSUML = 0XFC;  //Check SumĴλ
sfr   CHKSUMH = 0XFD;  //Check SumĴλ
sfr   OPERCON = 0XEF;  //ƼĴ

///* ------------------- λĴ-------------------- */
/*PSW*/
sbit  CY  = PSW^7;  //־λ          0:ӷλ޽λ߼λ޽λʱ	1:ӷλнλ߼λнλʱ
sbit  AC  = PSW^6;  //λ־λ  0:޽λλ	1:ӷʱbit3λнλbit3λнλʱ
sbit  F0  = PSW^5;  //û־λ
sbit  RS1 = PSW^4;  //Ĵѡλ
sbit  RS0 = PSW^3;  //Ĵѡλ
sbit  OV  = PSW^2;  //־λ
sbit  F1  = PSW^1;  //F1־
sbit  P   = PSW^0;  //ż־λ      0:ACC1ĸΪż0		1:ACC1ĸΪ

/*T2CON*/
sbit  TF2   = T2CON^7;  //ʱ2־λ
sbit  EXF2  = T2CON^6;  //T2EXⲿ¼(½)⵽ı־λ
sbit  RCLK  = T2CON^5;  //UART0ʱӿλ    0: ʱ1ղ	1: ʱ2ղ
sbit  TCLK  = T2CON^4;  //UART0ʱӿλ    0: ʱ1Ͳ	1: ʱ2Ͳ
sbit  EXEN2 = T2CON^3;  //T2EXϵⲿ¼(½)/񴥷/ֹ
sbit  TR2   = T2CON^2;  //ʱ2ʼ/ֹͣλ 0: ֹͣʱ2             1: ʼʱ2
sbit  T2    = T2CON^1;  //ʱ2ʱ/ʽѡλ2
sbit  CP    = T2CON^0;  ///طʽѡλ

/*IP*/
sbit  IPADC  = IP^6;  //ADCжȨѡ         0:趨 ADCжȨ ͡      1:趨 ADCжȨ ߡ
sbit  IPT2   = IP^5;  //Timer2жȨѡ      0:趨 Timer 2жȨ ͡	 1:趨 Timer 2жȨ ߡ
sbit  IPUART = IP^4;  //UARTжȨѡ        0:趨 UARTжȨ ͡     1:趨 UARTжȨ ߡ
sbit  IPT1   = IP^3;  //Timer1жȨѡ      0:趨 Timer 1жȨ ͡	 1:趨 Timer 1жȨ ߡ
sbit  IPINT1 = IP^2;  //INT1жȨѡ  0:趨 INT1жȨ ͡     1:趨 INT1жȨ ߡ
sbit  IPT0   = IP^1;  //Timer0жȨѡ      0:趨 Timer 0жȨ ͡	 1:趨 Timer 0жȨ ߡ
sbit  IPINT0 = IP^0;  //INT0жȨѡ  0:趨 INT0жȨΪ ͡     1: INT0жȨΪ

/*IE*/
sbit  EA    = IE^7;  //жʹܵܿ       0:رеж      1:еж
sbit  EADC  = IE^6;  //ADCжʹܿ        0:رADCж         1:ADCж
sbit  ET2   = IE^5;  //Timer2жʹܿ     0:رTIMER2ж      1:TIMER2ж
sbit  EUART = IE^4;  //UARTжʹܿ       0:رSIFж         1:SIFж
sbit  ET1   = IE^3;  //Timer1жʹܿ     0:رTIMER1ж      1:TIMER1ж
sbit  EINT1 = IE^2;  //ⲿж1жʹܿ  0:رⲿж1ж   1:ⲿж1ж	
sbit  ET0   = IE^1;  //Timer0жʹܿ     0:رTIMER0ж      1:TIMER0ж
sbit  EINT0 = IE^0;  //ⲿж0жʹܿ  0:رⲿж0ж   1:ⲿж0ж

/*TCON*/
sbit  TF1 = TCON^7;  //T1ж־λ	T1жʱӲTF1Ϊ1жϣCPUӦʱӲ塰0
sbit  TR1 = TCON^6;  //ʱT1пλ	0:Timer1ֹ		1:Timer1ʼ
sbit  TF0 = TCON^5;  //T0ж־λ	T0жʱӲTF0Ϊ1жϣCPUӦʱӲ塰0
sbit  TR0 = TCON^4;  //ʱT0пλ	0:Timer0ֹ		1:Timer0ʼ

/*SCON*/
sbit  SM0 = SCON^7;  //ͨģʽλ:SM1ʹ 00: ģʽ08λ˫ͬͨģʽ 01: ģʽ110λȫ˫첽ͨ 11: ģʽ311λȫ˫첽ͨ
sbit  SM1 = SCON^6;  //ͨģʽλ
sbit  SM2 = SCON^5;  //ͨģʽλ2˿λֻģʽ3Ч   0ÿյһ֡λRIж   1յһ֡ʱֻеRB8=1ʱŻλRIж
sbit  REN = SCON^4;  //λ  0:   1
sbit  TB8 = SCON^3;  //ֻģʽ3ЧΪݵĵ9λ
sbit  RB8 = SCON^2;  //ֻģʽ3ЧΪݵĵ9λ
sbit  TI  = SCON^1;  //жϱ־λ
sbit  RI  = SCON^0;  //жϱ־λ

/******************* P0 ******************
*SC92F8483װδĹܽţ
*SC92F8482װδĹܽţP06/P07
*SC92F8481װδĹܽţP02/P03/P04/P05/P06/P07
*SC92F8480װδĹܽţP0
******************************************/
sbit  P07 = P0^7;
sbit  P06 = P0^6;
sbit  P05 = P0^5;
sbit  P04 = P0^4;
sbit  P03 = P0^3;
sbit  P02 = P0^2;
sbit  P01 = P0^1;
sbit  P00 = P0^0;

/******************* P1 ******************
*SC92F8483װδĹܽţ
*SC92F8482װδĹܽţP16/P17
*SC92F8481װδĹܽţP16/P17
*SC92F8480װδĹܽţP14/P15/P16/P17
******************************************/
sbit  P17 = P1^7;
sbit  P16 = P1^6;
sbit  P15 = P1^5;
sbit  P14 = P1^4;
sbit  P13 = P1^3;
sbit  P12 = P1^2;
sbit  P11 = P1^1;
sbit  P10 = P1^0;

/******************* P2 ******************
*SC92F8483װδĹܽţ
*SC92F8482װδĹܽţP22/P23
*SC92F8481װδĹܽţP22/P23/P27
*SC92F8480װδĹܽţP22/P23/P25/P26/P27
******************************************/
sbit  P27 = P2^7;
sbit  P26 = P2^6;
sbit  P25 = P2^5;
sbit  P24 = P2^4;
sbit  P23 = P2^3;
sbit  P22 = P2^2;
sbit  P21 = P2^1;
sbit  P20 = P2^0;

/******************* P5 ******************
*SC92F8483װδĹܽţ
*SC92F8482װδĹܽţP50/P51
*SC92F8481װδĹܽţP50/P51
*SC92F8480װδĹܽţP50/P51
******************************************/
sbit  P51 = P5^1;
sbit  P50 = P5^0;

/****************************************************************************
*ע⣺װδĹܽţΪǿģʽ
*ICѡͣʹõICͺ,ڳʼIOں󣬵ӦδܽŵIO;
*ѡSC92F8483õú궨塣
*****************************************************************************/                                    
#define  SC92F8482_NIO_Init()   {P0CON|=0xC0,P1CON|=0xC0,P2CON|=0x0C,P5CON|=0x03;}//SC92F8482δIO
#define  SC92F8481_NIO_Init()   {P0CON|=0xFC,P1CON|=0xC0,P2CON|=0x8C,P5CON|=0x03;}//SC92F8481δIO
#define  SC92F8480_NIO_Init()   {P0CON|=0xFF,P1CON|=0xF0,P2CON|=0xEC,P5CON|=0x03;}//SC92F8480δIO

#endif